using System;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class DB_LOGDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public DB_LOGDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, DB_LOG objSave)
        {
            Int32? objReturn = objSave.CRS_DB_LOG_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    //LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_DB_LOG_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMMENTS, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.IS_ERROR, objSave.MESSAGE, objSave.PROCESS_NAME, objSave.STD_REGISTRY_ID);
                    //LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        #endregion
    }
}
